package examples.entity.uni.one_to_one;

import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import examples.entity.uni.one_to_one.interfaces.OrderShipment;

@Stateless
public class OrderShipmentUniBean implements OrderShipment {
	@PersistenceContext
	EntityManager em;
	
	public void doSomeStuff() {
		Shipment s = new Shipment();
		s.setCity("Austin");
		s.setZipcode("78727");
		
		Order o = new Order();
		o.setOrderName("Software Order");
		o.setShipment(s);
		
		em.persist(o);
	}

	public List getOrders() {
		Query q = em.createQuery("SELECT o FROM OrderUni o");
		return q.getResultList();
	}
}
